<html>
<head>
<title>FileArchiveSearch</title>
</head>
<body bgcolor=#ffffff>
<font face="arial,helvetica">
<script language="php">

/* This is FAS, version 0.6 Copyright (c) 2002 Tillmann Steinbrecher 

May be distributed according to the terms of the GNU General Public License,
Version 2. This program comes with NO WARRANTY.

Feedback and patches are welcome - email t-st@t-st.org */


/***************** Edit the following variables *************/

/* Directory where the list files will be located.
   Make sure commands executed by this PHP script have read and
   write permissions in this dir. */

$listfiledir="/home/tst/cd-listing";

/* Maximum number of hits to display in a single search */

$maxhits=300;

/* IP address of the admin. Deleting and adding list files is
   only possible from this IP.

   WARNING: if you're running a proxy server on this IP, all
   users of the proxy can add/delete list files. This is a
   situation to avoid!  */

$adminip="127.0.0.1";

/****** No more editing necessary below this line **********/

$linkto=$PHP_SELF;

function banner($text){
  echo "<table BORDER=0 CELLSPACING=0 CELLPADDING=7 WIDTH=\"90%\" BGCOLOR=\"#EBEBEB\">";
  echo "<tr><td ALIGN=LEFT><b><i><font face=\"arial,helvetica\">$text</font></i></b></td><tr></table><br>";
}

function del_select($link, $raddr){

  global $listfiledir;
  global $adminip;

  echo "<CENTER>";
  banner("Delete");
  echo "</CENTER><UL>";

  echo "<b>Warning</b>: List files will be permanently deleted.<br><br>";
  echo "Select CD list file to delete:";
  $command = "fas-list $listfiledir";

  $before_list = "<br><center>\n<table border=0 bgcolor=#FFFFFF cellspacing=8\n <tr>\n";
  $after_list = " </tr>\n</table>\n</center>\n";
  $items_per_row=4;
  $before_single_item = '  <td align=center bgcolor=#FFb8b8><font face="arial,helvetica">';
  $after_single_item  = "</font></td>\n";
  $newrow = " </tr>\n <tr>";

  if($raddr==$adminip){
  
    echo "</ul>";

    exec($command, $answer);
    sort($answer);

    echo $before_list;

    for($i=0; $i < count($answer); $i++) {
      echo $before_single_item;
      echo "<a href=\"$linkto?delcd=$answer[$i]\" ONCLICK=\"return confirm('Delete list file for ";
      echo rawurldecode($answer[$i]);
      echo "?')\" >";
      echo rawurldecode($answer[$i]);
      echo "</a>";
      echo $after_single_item;

      if((($i+1) % $items_per_row)==0 && ($i != (count($answer)-1))) echo $newrow;
		 
    }
    echo $after_list;
  } else {
    echo "<b>Error:</b>Files may only be deleted from local machine.";
}

}


function add_list($link, $raddr){

  global $listfiledir;
  global $adminip;

  $command = "fas-list $listfiledir";

  $before_list = "<br><center>\n<table border=0 bgcolor=#FFFFFF cellspacing=8\n <tr>\n";
  $after_list = " </tr>\n</table>\n</center>\n";
  $items_per_row=4;
  $before_single_item = '  <td align=center bgcolor=#ebebeb><font face="arial,helvetica">';
  $after_single_item  = "</font></td>\n";
  $newrow = " </tr>\n <tr>";

  echo "<center>";
  banner("CD list");
  echo "</center><ul>";

  if($raddr==$adminip){
  
    echo "<form action=$link>";
    echo "Enter name for new CD:";
    echo "<input type=\"text\" size=40 name = \"addcd\">";
    echo "<br><br><input type=\"checkbox\" name=\"cdrom[]\" value=\"0\">";
    echo "Use alternative drive for listing.&nbsp;&nbsp&nbsp;&nbsp;";
    echo "<input type = submit value=\"Add new CD\">";
    echo "</form>";
    echo "<br><br>CDs already in archive (reverse alphabetical order):";

  } else {
    echo "CDs can only be added from the local machine<br>";
    echo "CDs in archive (reverse alphabetical order):";
  }


  echo "</ul>";

  exec($command, $answer);
  rsort($answer);

  echo $before_list;

  for($i=0; $i < count($answer); $i++) {
    echo $before_single_item;
    echo "<a href=\"$link?lf=$answer[$i]&dir=\">";
    echo rawurldecode($answer[$i]);
    echo "</a>";
    echo $after_single_item;

  if((($i+1) % $items_per_row)==0 && ($i != (count($answer)-1))) echo $newrow;
		 
}
echo $after_list;



}


function getdirname($dn) {

	$newstr=strstr(substr($dn, 1, strlen($dn)-2), "/");
	if ($newstr==false) $newstr="";
	return $newstr;

}

function getfilename($fn) {

        /* The exact offset of the start of the filename in the ls -lR output 
	   depends on the version of ls. We can't use simple split to retrieve
	   filename, since the filename itself may also contain whitespaces.
	   So we determine the offset of the start of the filename using preg_split,
	   and then use substr */
	   
        $items=preg_split('/ +/', $fn, -1, PREG_SPLIT_OFFSET_CAPTURE);
	$fnitems=$items[8];
        $fnstart=$fnitems[1];
	return substr($fn, $fnstart, strlen($fn)-$fnstart);

}


function getfilesize($fn) {
        $items=preg_split('/ +/', $fn);
        return $items[4];

}

function displayline($line, $linkto, $cd, $dir){

	if($line[0]=="d") $isdir=true; else $isdir=false;

	        $filename=getfilename($line);
	  
	        echo "<b>";
	  
	  	if($isdir) {
		
		      echo "<a href=\"$linkto?dir=";
		      echo rawurlencode($dir);
		      echo rawurlencode("/");
		      echo rawurlencode($filename);
		      echo "&lf=$cd";
		      echo "\">";

		 
		 }
	  
	  	echo $filename;
	  
	  	if($isdir) echo "</a>";
	  

	  	$filesize=getfilesize($line);

	  	if ($isdir){
	  		echo "</b> (directory)<br>";
	        }
	
	  	else {
		        echo "</b> - $filesize bytes<br>";
	        }
	     
	  	echo "\n";


}



function searchfor($rawexp, $dironly, $linkto){

        global $maxhits;

	global $listfiledir;

	$regexp = str_replace(" ", ".{0,50}", $rawexp);

	$temp=$regexp;

	$regexp = str_replace("?", ".", $temp);

	$temp=$regexp;

	$regexp = str_replace("*", ".{0,50}", $temp);


	$command = "fas $listfiledir \"$regexp|:$\"";

	echo "<center><table BORDER=0 CELLSPACING=0 CELLPADDING=7 WIDTH=\"90%\" BGCOLOR=\"#EBEBEB\">";
	echo "<tr><td ALIGN=LEFT><i><font face=\"arial,helvetica\">";


	echo "<b>Search results for '$rawexp'</b>";

	if($dironly) echo " (searching for directories only)";
        echo ":</font></i></td><tr></table></center><ul>";

	echo "<p>\n";
	echo "<ul>\n";


	exec($command, $answer);



	for($i=0;$i<count($answer);$i++){

		$dirmarker=false;
		$separator=strpos($answer[$i], ":");
		$cdname = substr($answer[$i], 0, $separator);
	
		$rest = substr($answer[$i], $separator+1, strlen($answer[$i])-$separator);

		if($rest[0]=="d") $isdir=true; else $isdir=false;
	
		if($rest[strlen($rest)-1] == ":") {
	
			  $dirmarker = true;
			  $outputloc = true;
			  $currentdir=getdirname($rest);
	
		} 
		
			
		if(!$dirmarker && !(!$isdir && $dironly) && (strlen($rest)>16)) {
	  
			  $hits++;
			  
			  if($hits > $maxhits) {
			  	echo "</ul><p><b><font color=\"#ff0000\">Showing only the first $maxhits results.<br>";
				echo "Please use more specific keywords.</font></b>";
				return;
			  }
	  
		  	  if($outputloc){
	 	  	      echo "</ul><i><br><li>CD <a href=\"$linkto?lf=$cdname&dir=\">";
			      echo rawurldecode($cdname);
			      echo "</a>, directory ";
			      
			      
			      echo "<a href=\"$linkto?dir=";
			      echo rawurlencode($currentdir);
			      echo "&lf=$cdname";
			      echo "\">";
			      if ($currentdir=="") echo "/";
			      else echo $currentdir;
			      echo "</a>:";
			      
			      
			      echo" </li></i><br><br><ul>\n";
		              $outputloc=false;
	                  }	
	
			  displayline($rest, $linkto, $cdname, $currentdir);
                }
	   
/*	  echo "<br><font color=#ff0000>";
	  echo $answer[$i];
	  echo "</font><br>";
	  echo("\n<br>"); */

	  
	
	}

	if ($hits==0) echo "No occurences found, sorry.";
	else {
		if ($hits > 1) echo "</ul><p>Found $hits results.<ul>";
		else echo "</ul><p>Found only $hits result.<ul>";

        }



	echo "</ul>";
}


function browse($listfile, $dir, $linkto){
	
  	$count=0;
	
	global $listfiledir;
	
	$directory = str_replace("\\'", "'", $dir);

	echo "<li><i>Browsing ";
	if($directory=="") echo "root directory ";
	else echo "directory $directory ";
	echo "on $listfile</i></li><ul><p>";
	
	$listf = rawurlencode($listfile);

	$command = "fas-get $listfiledir $listf";

	exec($command, $answer);	

	if($directory!="") {
		$upperdir = substr($directory, 0, strrpos($directory, "/"));
		if($upperdir==false) $upperdir="";
		
		echo "<i><a href=\"$linkto?dir=";
		echo rawurlencode($upperdir);
		echo "&lf=";
		echo rawurlencode($listfile);
		echo "\">.. [higher level directory]</a></i><br><br>";
	
	}
	
			    	
	for($i=0;$i<count($answer);$i++){

	  if($answer[$i][strlen($answer[$i])-1] == ":") {
		if(getdirname($answer[$i])==$directory){
		  $i+=2;
		  while ($answer[$i]!="") {
		  	displayline($answer[$i], $linkto, $listfile, $directory);
		  	$i++;
			$count++;
		  }
		  echo "</ul><p>Total $count files.\n";
		  return;
		}
		
	  }  
	}
	
	echo "</ul><p>Error - not found.";	  
		
	

}

// ********** MAIN *********

if($dircheckbox[0]==1) $dironly = true;
else $dironly = false;


if(isset($term)) {
  if($term=="") { 
    echo "<center>";
    banner("Error: No search term supplied");
    echo "You gotta search for something!<br>";
  } else searchfor($term, $dironly, $PHP_SELF);
}

if(isset($lf) && isset($dir)){
  echo "<center>";
  banner("Browsing $lf");
  echo "</center><ul>";
  browse($lf, rawurldecode($dir), $PHP_SELF);
}

if(isset($addcd)) {
  $add = rawurlencode(ereg_replace("[&,+]", "and", $addcd));
  echo "<CENTER>";
  banner("Adding CD $addcd");
  echo "</CENTER><UL>";
  if (strcmp($add, $addcd)!=0) echo "<b>Note</b>: physical filename is for this list file is $add<br><br>";

  if($add=="") { echo "<b>Error</b>: you must enter a name for the new CD. Please use your browser's 'back' button and try again."; exit;}

  if($REMOTE_ADDR==$adminip){

    if(isset($cdrom)&& $cdrom=true) system("fas-add-alt $listfiledir  $add");
    else system("fas-add-default $listfiledir $add");

    echo "<br><br>";
    browse(rawurldecode($add), "",$PHP_SELF);
  } else {
    echo "<b>Permission denied</b> - CDs may only be added from the local machine.<br>Your IP: $REMOTE_ADDR. This incident was logged.";
  }
}


if(isset($delcd)) {
  echo "<CENTER>";
  banner("Deleting CD $delcd");
  echo "</CENTER><UL>";
  if($delcd=="") { echo "<b>Error</b>: you must enter a name for the CD to delete. Please use your browser's 'back' button and try again."; exit;}

  if($REMOTE_ADDR==$adminip){

    $dcd=rawurlencode($delcd);

    echo "Deleting list file $delcd (physical filename $dcd)";
    system("fas-del $listfiledir $dcd");


  } else {
    echo "<b>Permission denied</b> - CDs may only be deleted from the local machine.<br>Your IP: $REMOTE_ADDR. This incident was logged.";
  }
}


if(isset($list)) {
  add_list($PHP_SELF, $REMOTE_ADDR);
}

if(isset($del)) {
  del_select($PHP_SELF, $REMOTE_ADDR);
}

// display links at the end

echo "<br>";

echo "</UL><center>";

if(isset($term)){
 banner("Search again");
} else {
  banner("FileArchiveSearch");
  echo "<b>Enter search term</b> (wildcards '*' and '?' are allowed)";
}

echo "<form action=$PHP_SELF>";
echo "<input type=\"text\" size=40 name = \"term\" value=\"$term\">\n";
echo "<input type = submit value = \"Search\"><br>\n";
echo "<input type=\"checkbox\" name=\"dircheckbox[]\" value=\"1\">\n";
echo " Search for directories only";
echo "<p><b>\n";

if($REMOTE_ADDR==$adminip){

  echo "[<a href=\"$PHP_SELF?list=1\">Add/List CDs</a>]&nbsp;&nbsp;&nbsp \n";
  echo "[<a href=\"$PHP_SELF?del=1\">Delete CDs</a>] \n";

  } else {
   
  echo "[<a href=\"$PHP_SELF?list=1\">View list of all CDs</a>]&nbsp;&nbsp;&nbsp \n";

  }

echo "</center></b>";
	
</script>
</body>
</html>
